(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, cellOutline, groupLikeTitle, center, M7, O522, bold, B65535, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, O522, italic, e6,  24, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, O522, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, O522, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, O522, bold, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  14, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, O522, bold, L-5,  12, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, L-5,  12, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, O522, G65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, O522, l34, w240, h244,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, R65535, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, blackDot, M7, O522, B65535, r58981, g58981, b58981,  12, "Palatino"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, cellOutline, blackDot, M7, O522, r58981, g58981, b58981,  14, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, O522, B65535, b0,  14, "Times"; 
	paletteColors = 128; showRuler; automaticGrouping; currentKernel; 
]
:[font = special2; inactive; preserveAspect]
Name(s): 
:[font = subsubtitle; inactive; preserveAspect]
Exploring Abstract Algebra with Mathematica
Al Hibbard and Ken Levasseur
 Copyright 1998 by Springer Verlag New York, Inc.
;[s]
4:0,0;44,1;72,0;73,2;124,-1;
3:2,25,18,Times,2,24,0,0,0;1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = title; inactive; preserveAspect; startGroup]
Lab 0. Getting started with Mathematica
;[s]
3:0,0;28,1;39,0;40,-1;
2:2,25,18,Times,1,24,0,0,65535;1,25,18,Times,3,24,0,0,65535;
:[font = text; inactive; preserveAspect]
This lab is intended to be an introduction to using Mathematica. There are several key skills and concepts that need to be mastered to ensure success with the labs in Exploring Abstract Algebra with Mathematica. They are:

1. how to recognize nested cells

2. how to open and close nested cells

3. how to evaluate an expression in an input cell

4. how to create an input cell in order to create one's own Mathematica input

5. learn some of the general principles of Mathematica syntax

6. learn where to get more help
;[s]
11:0,0;52,1;63,0;167,1;198,0;199,1;210,0;407,1;418,0;469,1;480,0;521,-1;
2:6,16,12,Times,0,14,0,0,0;5,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
Let's begin with the first two goals. For users of Mathematica 2.2, every cell has one or more brackets surrounding it on the right side of the window. For users of version 3.0 or higher, the brackets may be replaced by, or supplemented with, arrows (triangles) that can be toggled on the left. For instance, look at the next cell, headed by the title "0.0 Note regarding Exploring Abstract Algebra with Mathematica" (you may need to scroll down to see it). Note that this cell has a standard square bracket as well as another bracket to its right that looks somewhat like a harpoon. This indicates that there are cells nested inside. When you move the cursor over the bracket with the harpoon, the cursor takes on the shape of an arrow pointing left toward a vertical bar. When the cursor has this shape, you can double-click on the harpoon. This will open up to reveal the inner, nested cells. Try this now with any of these first three sections (0.0, 0.1, or 0.2); after reading any or all of these, proceed to section 0.3 and open it up to continue.
;[s]
5:0,0;51,1;62,0;404,1;415,0;1054,-1;
2:3,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
0.0 Note regarding Exploring Abstract Algebra with Mathematica
;[s]
2:0,0;51,1;63,-1;
2:1,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
This lab is intended to supplement an abstract algebra course. It is part of a series of labs and packages under the name Exploring Abstract Algebra with Mathematica, a joint project by Al Hibbard (Central College) and Ken Levasseur (UMass-Lowell). This is also the title of a book published by Springer Verlag that contains this lab. This book includes labs for group theory, labs for ring theory, and a user's guide.
;[s]
3:0,0;122,1;165,0;419,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
For more information on the Exploring Abstract Algebra with Mathematica project, go to our web site at http://www.central.edu/eaam.html. This site is also mirrored at http://www.uml.edu/Dept/Math/eaam/eaam.html. There you will find the latest versions of the packages in AbstractAlgebra, the latest palettes available to supplement AbstractAlgebra, and other related resources.
;[s]
7:0,0;28,2;71,0;103,1;135,0;167,1;210,0;378,-1;
3:4,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = text; inactive; preserveAspect]
You may also contact either of the authors:

Al Hibbard
Central College
Pella, IA 50219
hibbarda@central.edu

Ken Levasseur
UMass Lowell
Lowell, MA 01854
Kenneth_Levasseur@uml.edu
:[font = text; inactive; preserveAspect; endGroup]
Last revision: June 9, 1998

 Copyright 1998 Springer Verlag New York, Inc.
;[s]
2:0,0;29,1;77,-1;
2:1,16,12,Times,0,14,0,0,0;1,12,9,Times,0,10,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
0.1 Prerequisites
:[font = text; inactive; preserveAspect; endGroup]
There are no prerequisites for this lab.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
0.2 Goals for this lab
:[font = text; inactive; preserveAspect; endGroup]
This lab is intended to introduce a few of the basics of Mathematica, as well as introduce a few rudimentary algebraic ideas.
;[s]
3:0,0;57,1;68,0;126,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
0.3 The In's and Out's of evaluating Mathematica expressions
;[s]
3:0,0;37,1;48,0;61,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
These nested cells are not too difficult to open up, once you get the hang of it, right?
:[font = special3; inactive; preserveAspect]
Q1. Go to section 0.4 (below) and open up the nested cells. What do you find inside at the inner-most nested level?
;[s]
2:0,1;2,0;116,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
You may have noticed that some cells appear differently than others. For instance, this text is in a Text cell, while the cell heading this section (0.3) is called a Section cell. If you go up and click anywhere in the characters of the section 0.3 cell, you will see the word Section appear in the pop-up menu in the ruler at the top of the window. This menu indicates the current cell type; it can also be used to change one type of cell to another. To tell Mathematica to compute an evaluation, we need to use a special type of cell, called an Input cell. Consider the cell below:
;[s]
11:0,0;101,1;105,0;166,1;173,0;277,1;284,0;460,2;471,0;547,1;552,0;584,-1;
3:6,16,12,Times,0,14,0,0,0;4,15,11,Courier,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
26/3
:[font = text; inactive; preserveAspect]
Click the cursor anywhere in the body of the cell above, or select its cell bracket. (Note that the name of the cell type becomes Input in the pop-up menu in the ruler.) To evaluate this cell (assuming you have clicked in the cell or selected its bracket), press the SHIFT/RETURN key combination (or just the ENTER key on a Macintosh). Mathematica will then evaluate this request and return its value. Do so.

Do not be too disappointed with the result; Mathematica always tries to return an exact result whenever possible. In this case, 26/3 is more exact than 8.7 or 8.6667 or 8.666666667. Each of these approximations can be obtained as follows (evaluate this next cell):
;[s]
9:0,0;130,1;135,0;173,2;181,0;336,2;347,0;454,2;465,0;675,-1;
3:5,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;3,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
{N[26/3, 2], N[26/3, 5], N[26/3, 10]}
:[font = special3; inactive; preserveAspect]
Q2. Evaluate the cell below. (Remember, use SHIFT/RETURN.) What do these results have in common with the above approximations of 26/3?
;[s]
2:0,1;2,0;135,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect]
N[{29/3, 23/3, 20/3}]
:[font = text; inactive; preserveAspect]
The next thing to learn is how to make your own Input cell so that you can type your own request. Move the cursor (slowly) right below the text in this paragraph. As you move it, you should see the cursor take on one or more of the following shapes: a horizontal I-beam, a down-arrow, a circle with a plus, a vertical I-beam or possibly other shapes. When it is just below this text, but yet above the next cell, you should see the cursor become a horizontal I-beam. Upon clicking the mouse when this cursor is present, a horizontal line appears in the window. You can now start typing and you are automatically in the Input style.
;[s]
5:0,0;48,1;53,0;619,1;624,0;632,-1;
2:3,16,12,Times,0,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special3; inactive; preserveAspect]
Q3. Above this cell, but below the paragraph of text, create an input cell, type in 17/3, and evaluate the cell. Create another cell and determine the decimal approximations of 14/3 and 11/3. What do these results have in common with previous results?
;[s]
2:0,1;2,0;252,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q4. Evaluate the following Input cell. Next, create a new input cell and either retype the line just evaluated or copy it and paste it in the new cell. (You are not expected to understand what these instructions in the Input cell mean.) Before evaluating, change the 2 to a 1. What do the results in the output have in common? How do they compare to the previous output?
;[s]
6:0,1;2,0;27,2;32,0;219,2;224,0;371,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect; endGroup]
Map[N[#/3]&, Range[2,30,3]]
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
0.4 What is inside?
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
You have to open up each layer to find out.
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
Is there another level inside this?
:[font = text; inactive; preserveAspect; endGroup; endGroup; endGroup]
No. A subsubsection is the lowest level here.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
0.5 Some syntax basics
:[font = text; inactive; preserveAspect]
Recall above where we evaluated the following cell; evaluate it again.
:[font = input; preserveAspect]
N[{29/3, 23/3, 20/3}]
:[font = text; inactive; preserveAspect]
Mathematica is very particular in expecting the exact syntax for communicating requests. For example, the following are incorrect methods (for various reasons) of inputting the previous cell.
;[s]
2:0,1;11,0;192,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
(* example 1 *) n[{29/3, 23/3, 20/3}]
:[font = input; preserveAspect]
(* example 2 *) N[(29/3, 23/3, 20/3)]
:[font = input; preserveAspect]
(* example 3 *) N({29/3, 23/3, 20/3})
:[font = input; preserveAspect]
(* example 4 *) N[{29/3 23/3 20/3}]
								N[{29/3; 23/3; 20/3}]
:[font = input; preserveAspect]
(* example 5 *) N[{29/3, 23/3, 20/3]}
:[font = text; inactive; preserveAspect]
In addition to the error messages that were given, here are additional reasons why these are incorrect:

1. All Mathematica commands or functions start with capital letters.

2. Lists are always enclosed with curly brackets {}; parentheses are only used for grouping expressions to alter the standard order of operations (such as (a+b)^2 in contrast to a+b^2).

3. Arguments for functions (such as the N function in this case) must always be enclosed in square brackets [], not parentheses (which are only used as grouping symbols).

4. Lists must always have their elements separated by commas. (Here the terms were multiplied, in the first instance, since a space implies multiplication.)

5. Of the three types of brackets, (), {}, and [], each type can only be used for
the specific use for which it is intended. Furthermore every left bracket must
have a matching right bracket of the same type.
;[s]
5:0,0;112,1;123,0;402,2;403,0;901,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special3; inactive; preserveAspect]
Q5. Evaluate the following Input cell. What error(s) does it have? Correct the error(s) and arrive at the intended input.
;[s]
4:0,1;2,0;27,2;32,0;122,-1;
3:2,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = input; preserveAspect; endGroup]
Expand[{x+y}^2)
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
0.6 Help
:[font = text; inactive; preserveAspect]
Mathematica has a sophisticated help facility called the Help Browser (or Function Browser for 2.2 users). The last item on Mathematica's menubar is the Help menu. Choose this and select the first item (Help in 3.x or Open Function Browser in 2.2). In the browser in version 2.2, you have the choice of reviewing the use of any names in the Built-in Functions, Packages, or Loaded Packages by pressing the appropriate button. (For Loaded Packages, first press the Update button.) In version 3.0 or later, the browser is much more sophisticated. In addition to the previous three categories, one can find the whole Mathematica book on-line, as well as an index to it and all the packages, in addition to other information. This browser is a Mathematica notebook and not just a static display device as in version 2.2. Try it out and find out for yourself. To learn more about the functions in Exploring Abstract Algebra with Mathematica in version 3.x, click on the Add-ons button and AbstractAlgebra should show up in the first column if a correct installation has been made (including a call to Rebuild Help Index, the last item on the Help menu).
;[s]
38:0,1;11,0;57,2;69,0;74,2;90,0;124,1;135,0;153,2;157,0;203,2;207,0;219,2;240,0;343,2;361,0;363,2;371,0;376,2;391,0;433,2;448,0;466,2;472,0;616,1;627,0;742,1;753,0;894,1;937,0;967,2;974,0;986,2;1001,0;1098,2;1116,0;1139,2;1143,0;1151,-1;
3:19,16,12,Times,0,14,0,0,0;5,16,12,Times,2,14,0,0,0;14,15,11,Courier,0,14,0,0,0;
:[font = special3; inactive; preserveAspect]
Q6. Using the help facility, learn more about the Expand function. What does this function do? (Hint: Expand is a built-in function used for algebraic computations in basic algebra.)
;[s]
6:0,1;2,0;50,2;56,0;102,2;108,0;183,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect; endGroup]
Another feature that occurs only in version 3.x is the use of hyperlinks. By clicking on any underlined, blue text, one can be linked to another part of the notebook (or a different notebook altogether), the main book in the Help Browser, package documentation in the Help Browser, or even to a web page.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
0.7 Using Mathematica to learn a mod idea
;[s]
3:0,0;10,1;21,0;42,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
Above we saw that 26/3, 29/3, 23/3 and several other fractions all had one thing in common: the quotient had a decimal part returning .666667, or in other words, upon division by 3, the remainder was always two. Observe:
:[font = input; preserveAspect]
26 == 8*3 + 2
:[font = input; preserveAspect]
29 == 9*3 + 2
:[font = input; preserveAspect]
23 == 7*3 + 2
:[font = text; inactive; preserveAspect]
In each case, we see that the numbers 26, 29 and 23 have a remainder of two upon division by 3. We can see this visually as well. First, select all the cells in the following subsection. (You do not need to open up the subsection, simply select the outer harpoon bracket surrounding it.) Next, evaluate (use SHIFT/RETURN) all these cells. This will define some functions we will be using. Then go to the next section.
;[s]
3:0,0;238,1;244,0;418,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Evaluate all cells in this subsection
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
usage/messages
:[font = input; preserveAspect; endGroup]
Off[General::spell,General::spell1];

Needs["Graphics`Colors`"]

IllustrateModReduction::arg = "The first argument of 
IllustrateModReduction must be an integer and the second must be a 
positive integer.";

IllustrateModAddition::arg = "The first two arguments of 
IllustrateModAddition must be integers and the third must be a 
positive integer.";

IllustrateModAddition::usage = "IllustrateModAddition[a_, b_, n_]
is a function which takes three integer arguments. The purpose of 
the function is to illustrate how the number 'a' (first arg) is 
added to 'b' (second arg) using modulo 'n' (third arg) arithmetic. 
It draws bars of multiples of n and the remainders and regroups to 
show the addition.";
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
IllustrateModReduction
:[font = input; preserveAspect; endGroup]
IllustrateModReduction[a_Integer,n_Integer?Positive,opts___] := 
	Show[computeModReduction[a,n,opts]];
	
IllustrateModReduction[a_, n_, opts___] :=
	Message[IllustrateModReduction::arg]

Options[computeModReduction]={showText->True,
	dotColor->Blue};

textPortionOfReduction[a_,n_,r_,q_] :=
	(Print[a," mod ",n," is ",Mod[a,n],
		" since ",a," = ",Quotient[a,n],
		"*",n," + ",Mod[a,n],".\n"];
	Print["In other words, ",a," mod ",n,
		" is the remainder "];
	Print["upon division of ",a," by " ,
		n,".\n"];
	If[a > 0, Print["To illustrate, ","below ",
			If[q == 1, "is ","are "], q, " full column",
			If[q =!= 1,"s",""]];
		Print["of height ",n, If[r > 0,
		" and one column with height ",""],
		If[r > 0,r,""],"."];
	If[r == 0, Print["Since there is no remainder, ",a," mod ",
		n," is 0."],
		Print["Since the remainder is ",r,", ",a," mod ",
		n," is ",r,"."]]])

computeModReduction[a_,n_,opts___] := 
	Module[{r,q,showtext,dotcolor},
	SetOptions[Graphics,AspectRatio->1/GoldenRatio];
	r = Mod[a,n];
	q = Quotient[a,n];
	dotcolor = dotColor/.{opts}/.Options[computeModReduction];
	showtext = showText/.{opts}/.Options[computeModReduction];
	If[showtext,textPortionOfReduction[a,n,r,q]];
	If[q == 0, makeDots[1,1,r,dotcolor,Yellow,0.025],
		If[r == 0, makeDots[1,q,n,dotcolor,Red,0.025,
			colLabels->True],
		{makeDots[1,q,n,dotcolor,Red,0.025,colLabels->True],
		makeDots[q+1.5,1,r,dotcolor,Yellow,0.025]}]]
	]
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
IllustrateModAddition
:[font = input; preserveAspect; endGroup]
IllustrateModAddition[a_Integer,b_Integer,n_Integer?Positive] := 
	Module[{ra,rb,qa,qb},
	SetOptions[Graphics,AspectRatio->1/GoldenRatio];
	ra = Mod[a,n];
	qa = Quotient[a,n];
	rb = Mod[b,n];
	qb = Quotient[b,n];
	Print["We wish to calculate ", a," mod ",n,"  +  ",
		b," mod ",n,"."];
	Print["To do so, we determine the quotients and
	remainders when"];
	Print[a," and ",b," are divided by ",
		n,"."];
	showStageOne[ra,rb,qa,qb,n];
	If[qa+qb > Max[qa,qb] && ra+rb > Max[ra,rb],
		showStageTwo[ra,rb,qa,qb,n]];
	If[qa=!= 0 && qb =!= 0,showStageThree[ra,rb,qa,qb,n]];
	If[n>ra+rb,showStageFive[ra,rb,qa,qb,n],
		showStageFour[ra,rb,qa,qb,n];
		showStageFive[ra,rb,qa,qb,n]];]
		
IllustrateModAddition[a_, b_, n_] :=
	Message[IllustrateModAddition::arg]
	
showStageOne[ra_,rb_,qa_,qb_,n_] := 
	Show[{makeDots[1,qa,n,Blue,Red,0.025,colLabels->True],
		makeDots[1+qa+.5,1,ra,Blue,Yellow,0.025],
		makeDots[1+qa+3,qb,n,Black,Red,0.025,colLabels->True],
		makeDots[1+qa+3+qb+.5,1,rb,Black,Yellow,0.025]},
		PlotLabel->StringJoin[ToString[qa n + ra]," = ",
		ToString[qa],"*",ToString[n]," + ",ToString[ra],
		" and \n", ToString[qb n + rb]," = ",
		ToString[qb],"*",ToString[n]," + ",ToString[rb]]]
		
showStageTwo[ra_,rb_,qa_,qb_,n_] :=
	Show[{makeDots[1,qa,n,Blue,Red,0.025,colLabels->True],
		makeDots[1+qa+1,qb,n,Black,Red,0.025,
			colLabels->True],
		makeDots[1+qa+1+qb+2,1,ra,Blue,Yellow,0.025],
		makeDots[1+qa+1+qb+4,1,rb,Black,Yellow,0.025]},
		PlotLabel->StringJoin["Combining our multiples of ",
		ToString[n],"\nand our remainders..."]]
		
showStageThree[ra_,rb_,qa_,qb_,n_] :=
	Show[{makeDots[1,qa,n,Blue,Red,0.025,colLabels->True],
		makeDots[1+qa,qb,n,Black,Red,0.025,
			rowLabels->False,colLabels->True,colStart->1+qa],
		makeDots[1+qa+qb+2,1,ra,Blue,Yellow,0.025],
		makeDots[1+qa+qb+3.5,1,rb,Black,Yellow,0.025]},
		PlotLabel->StringJoin["results in ",ToString[qa+qb],
		" multiples of ", ToString[n],"\nwith remainders ",
		ToString[ra]," and ",ToString[rb],"."]]

showStageFour[ra_,rb_,qa_,qb_,n_] :=
	Show[{makeDots[1,qa+qb,n,TurquoiseDark,Red,0.025,
			colLabels->True],
		makeDots[1+qa+qb+2,1,Min[ra+rb,n],TurquoiseDark,
			Yellow,0.025],
		makeDots[1+qa+qb+3.5,1,ra+rb-n,TurquoiseDark,
			Yellow,0.025]},
		PlotLabel->StringJoin["Since the remainders add up to
at\nleast ",ToString[n],", we form a multiple of ",
		ToString[n],"\nand determine the new remainder."]]

showStageFive[ra_,rb_,qa_,qb_,n_] :=
	Show[{makeDots[1,qa+qb +Quotient[rb+ra,n],n,TurquoiseDark,
			Red,0.025,colLabels->True],
		makeDots[1+qa+qb+2,1,Mod[ra+rb,n],TurquoiseDark,
			Yellow,0.025]},
		PlotLabel->StringJoin["Finally, we have our multiples of ",
		ToString[n], " and\nonly consider the remainder.",
		" Thus,\n",ToString[qa n + ra]," mod ",ToString[n],
		"  +  ",ToString[qb n + rb]," mod ",ToString[n],
		"  =  ",ToString[Mod[ra+rb,n]]," mod ",ToString[n]]]
:[font = subsubsection; inactive; Cclosed; preserveAspect; startGroup]
core functions for IllustrateModReduction and IllustrateModAddition
:[font = input; preserveAspect; endGroup; endGroup]
makeDots[xStart_, width_, height_, dotcolor_, backcolor_,
		dotsize_,opts___] :=
	Module[{adj = 0.4, i, j, crds,bcrds,tcrds,rcrds,ccrds,
			rl,cl,cs},
		rl = rowLabels/.{opts}/.Options[makeDots];
		cl = colLabels/.{opts}/.Options[makeDots];
		cs = colStart/.{opts}/.Options[makeDots];
		crds = Table[{i+xStart-1,j},{i,width},{j,height}];
		(*Print[crds];*)
		If[crds == {} || crds == {{}},
			nullGraphics[],
			(* else *)
			ccrds = Last[Transpose[crds]]+
				Table[{0,0.75},{width}]; (* coords for 
				column labels *)
			rcrds = First[crds]+Table[{-0.5,0},{height}];
			bcrds = First[Transpose[crds]];
			tcrds = Last[Transpose[crds]];
			rects = Table[Rectangle[bcrds[[i]]+{-adj,-adj},
				tcrds[[i]]+{adj,adj}],{i,width}];
			Graphics[{
				If[rl,
					{Evaluate[Table[Text[ToString[i],rcrds[[i]],
					{1,0}],{i,height}]]},
					(* else *)nullPreGraphics[]],
				If[cl,
					{Evaluate[Table[Text[ToString[i+cs-1],
						ccrds[[i]],{0,0}],{i,width}]]},
					(* else *)nullPreGraphics[]],
				{backcolor,rects},
				{PointSize[dotsize],dotcolor,
					Map[Point,Flatten[crds,1]]}}]]
	]

Options[makeDots]={rowLabels->True,colLabels -> False,
	colStart->1};

nullGraphics[] := Graphics[{White,Rectangle[{1,1},{1,1}]}]

nullPreGraphics[] := {White,Rectangle[{1,1},{1,1}]}
:[font = subsection; inactive; Cclosed; preserveAspect; startGroup]
Continue on in this subsection
:[font = text; inactive; preserveAspect]
By evaluating the cell below, you can see why 2 is the remainder of 26 upon division by 3.
:[font = input; preserveAspect]
IllustrateModReduction[26, 3];
:[font = text; inactive; preserveAspect]
Note that the word "mod" is used in the function name. We say 26 mod 3 is 2 because 2 is the remainder when 26 is divided by 3. Mathematica can compute this directly as follows:
;[s]
3:0,0;128,1;139,0;178,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
Mod[26, 3]
:[font = text; inactive; preserveAspect]
Note that each of 29, 26 and 23, when reduced modulo 3, results in the value 2.
:[font = input; preserveAspect]
{Mod[29, 3], Mod[26, 3], Mod[23, 3]}
:[font = text; inactive; preserveAspect]
In other words, 2 is the remainder when 29 is divided by 3 and when 23 is divided by 3. These can be seen visually as well; evaluate one or both of the following.
:[font = input; preserveAspect]
IllustrateModReduction[29, 3];
:[font = input; preserveAspect]
IllustrateModReduction[23, 3];
:[font = special3; inactive; preserveAspect]
Q7. Determine the values of 22 mod 3, 25 mod 3 and 28 mod 3 using either the Mod function or the IllustrateModReduction function. What do these three values have in common? How are 22, 25 and 28 related to each other?
;[s]
6:0,1;2,0;77,2;80,0;97,2;119,0;218,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = special3; inactive; preserveAspect]
Q8. Determine the values of 21 mod 3, 24 mod 3 and 27 mod 3 using either the Mod function or the IllustrateModReduction function. What do these three values have in common? How are 21, 24 and 27 related to each other?
;[s]
6:0,1;2,0;77,2;80,0;97,2;119,0;218,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;2,15,11,Courier,0,14,0,0,0;
:[font = special2; inactive; preserveAspect; endGroup; endGroup]
Answer: 
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
0.8 Divide and conquer
:[font = text; inactive; preserveAspect]
Select the input cell below. After evaluating it, come back here and finish reading this text. There are some mathematical observations to make, as well some Mathematica observations. First, note that this is showing k mod 3 for k running from 18 to 28. As you look at the value of this (the value of the remainder of k divided by 3, which is also the height of the yellow rectangle), note how it cycles through 0 to 1 to 2 to 1 to 2 and so on. Do you know why?

Second, note that all the graphics are each in their own cell but there is also one cell that surrounds the whole collection of graphics. Put the cursor over this surrounding bracket and double-click. This will close up and hide the nested cells with only the first one showing. If one now double-clicks on the top graphic, an animation should take place. Since the motion may be going too fast, you may want to know how to adjust it. Typing any number from 1 to 9 adjusts the speed (1 slow and 9 fast), while pressing an up-arrow or down-arrow key causes one step to be taken in the specified direction. Try it.
;[s]
3:0,0;158,1;169,0;1076,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
Do[IllustrateModReduction[k, 3, showText -> False], {k, 18, 28}]
:[font = text; inactive; preserveAspect]
For each of the cases where the remainder is zero (ie., k mod 3 = 0), observe that this happens because 3 is a divisor of k. Mathematically, we say "3 divides k" and denote this by 3 | k. Consider k = 24 and j = 30. In both cases we have 3 as a divisor. There are, however, other divisors of each. In previous course-work, you may have encountered the notion of the greatest common divisor, or gcd. In this case, the gcd of 24 and 30, frequently denoted gcd(24, 30) or simply (24, 30), is actually 6. Here is we get Mathematica to confirm this. (Note the capital letters.)
;[s]
5:0,0;366,1;389,0;516,1;527,0;573,-1;
2:3,16,12,Times,0,14,0,0,0;2,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
GCD[24, 30]
:[font = special3; inactive; preserveAspect]
Q9. What is the gcd of 242652 and 3054876?
;[s]
2:0,1;2,0;43,-1;
2:1,16,12,Times,0,14,0,0,0;1,16,12,Times,1,14,0,0,0;
:[font = special2; inactive; preserveAspect]
Answer: 
:[font = text; inactive; preserveAspect]
Suppose we consider the problem of determining the gcd of two fairly large numbers, say a = 1234567891011121314 and b = 1413121110987654321. 
:[font = input; preserveAspect]
a = 1234567891011121314
b = 1413121110987654321
:[font = text; inactive; preserveAspect]
We will pursue the gcd in two ways. First, we will find all the divisors of a (and record how much time this took).
;[s]
5:0,0;56,1;59,0;76,2;77,0;116,-1;
3:3,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
diva = Divisors[a]//Timing
:[font = text; inactive; preserveAspect]
And then do the same for b.
;[s]
3:0,0;25,1;26,0;28,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
divb = Divisors[b]//Timing
:[font = text; inactive; preserveAspect]
Then we take the intersection of the list of divisors and ask for the maximum value. (Note that diva and divb consist of a list containing both the time and the list of divisors. Since we want the second part, the list of divisors, we specify this by using the notation diva[[2]].)
;[s]
7:0,0;96,1;100,0;105,1;109,0;270,1;279,0;282,-1;
2:4,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
max = Max[Intersection[diva[[2]], divb[[2]]]]//Timing
:[font = text; inactive; preserveAspect]
Thus, we see that the gcd is 3. How much time did this take? We add up the amounts found in the first part of each result:
:[font = input; preserveAspect]
totalTime = diva[[1]] + divb[[1]] + max[[1]]
:[font = text; inactive; preserveAspect]
Now let's see how long it takes for the GCD function?
:[font = input; preserveAspect]
GCD[a, b]//Timing
:[font = text; inactive; preserveAspect; endGroup]
Is this surprising? The GCD function did not use any previous results to enable it to be fast, but rather the method of calculating the gcd happens to be a very fast algorithm called the Euclidean Algorithm. Hopefully, you will be learning more about this algorithm in this course; we will see it in these labs when we study polynomial rings in Ring Lab 6. If you increase the number of digits in a and b by only a few, the time difference will be even more dramatic.
;[s]
7:0,0;24,1;27,0;397,1;398,0;403,1;404,0;468,-1;
2:4,16,12,Times,0,14,0,0,0;3,15,11,Courier,0,14,0,0,0;
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
0.9 It all adds up
:[font = text; inactive; preserveAspect]
Above we saw how the values of k mod 3 (Mod[k, 3]) are 0, 1 or 2.
;[s]
3:0,0;40,1;49,0;66,-1;
2:2,16,12,Times,0,14,0,0,0;1,15,11,Courier,0,14,0,0,0;
:[font = input; preserveAspect]
Table[Mod[k, 3], {k, 18, 28}]
:[font = text; inactive; preserveAspect]
A question that algebraists ask in such a situation is "Does the set {0, 1, 2} have any other structure?" In other words, is there a natural operation that may exist between, for example, 14 mod 3 and 16 mod 3? In particular, does this answer have anything to do with 30 mod 3?
:[font = input; preserveAspect]
Mod[14, 3]
Mod[16, 3]
Mod[30, 3]
:[font = text; inactive; preserveAspect]
This can be illustrated visually below.
:[font = input; preserveAspect]
IllustrateModAddition[14, 16, 3]
:[font = text; inactive; preserveAspect]
Note that 14 mod 3 plus 14 mod 3 (ie. 2 "plus" 2) yields 1, which is 28 mod 3.
:[font = input; preserveAspect]
Mod[14, 3]
Mod[14, 3]
Mod[28, 3]
:[font = input; preserveAspect]
IllustrateModAddition[14, 14, 3]
:[font = text; inactive; preserveAspect; endGroup]
The collection of values where the integers are reduced by some modulus (3 in this example) forms a very interesting structure for algebraists. Much more will be said about this in the future.
:[font = section; inactive; Cclosed; preserveAspect; startGroup]
0.10 Mathematica commands used in this lab
;[s]
3:0,0;5,1;16,0;43,-1;
2:2,19,14,Times,1,18,0,0,0;1,19,14,Times,3,18,0,0,0;
:[font = text; inactive; preserveAspect]
If you wish to learn more about how to use the Mathematica commands or functions used in this lab, type ? followed by the command. Below are some used in this lab that may be useful for later work.
;[s]
3:0,0;47,1;58,0;198,-1;
2:2,16,12,Times,0,14,0,0,0;1,16,12,Times,2,14,0,0,0;
:[font = input; preserveAspect]
?N
:[font = input; preserveAspect]
?Map
:[font = input; preserveAspect]
?Range
:[font = input; preserveAspect]
?Expand
:[font = input; preserveAspect]
?Mod
:[font = input; preserveAspect]
?GCD
:[font = input; preserveAspect]
?Divisors
:[font = input; preserveAspect]
?Timing
:[font = input; preserveAspect; endGroup; endGroup]
?Table
^*)
